

CompScans_95toA_PD <- function(dataf,datafA){
  
dataf$PTM_Final_prob <- (dataf$ptmRS_Score/100)*(1-dataf$PEP)
datafA$PTM_Final_prob <- (datafA$ptmRS_Score/100)*(1-datafA$PEP)

dataf$SiteID <- paste0(dataf$Unique_scan,"_", dataf$PTM_Positions)
datafA$SiteID <- paste0(datafA$Unique_scan,"_", datafA$PTM_Positions)

dataf$Peptide_mod <- paste0(dataf$Sequence,"_",gsub("\\s*\\([^\\)]+\\)","",as.character(gsub( ';', '_',dataf$Modifications))))

dataf$Peptidoform <- paste0(dataf$Peptide_mod,"_", dataf$PTM_Positions)

dataf_pform <- dataf %>% group_by(Peptidoform) %>% top_n(1, PTM_Final_prob)

dataf_95_pform <- dataf_pform[dataf_pform $PTM_Final_prob>=0.95,]

Reduceddataf_95 <- subset(dataf_95_pform,select = c(Unique_scan,Sequence,Single_Mod,PTM_Final_prob))

Reduceddataf_95 <- Reduceddataf_95 %>% dplyr::rename(
  pSTY_Score = PTM_Final_prob
)

ReduceddatafA <- subset(datafA,select = c(Unique_scan,Sequence,Single_Mod,PTM_Final_prob))

ReduceddatafA <- ReduceddatafA %>% dplyr::rename(
  SequenceSTYA = Sequence,
  Single_ModSTYA = Single_Mod,
  pASTY_Score = PTM_Final_prob
)


dataf_Merged_95 <- merge(x=Reduceddataf_95,y=ReduceddatafA,by="Unique_scan", all.x = TRUE)
dataf_Merged_95$SeqMatch <- ifelse(dataf_Merged_95$Sequence==dataf_Merged_95$SequenceSTYA,1,0)

NoMatchSeq_95 <- subset(dataf_Merged_95,SeqMatch==0 | is.na(SeqMatch))

MatchSeq_95 <- subset(dataf_Merged_95,SeqMatch==1 )

Scans_NMSeq_95 <- length(unique(NoMatchSeq_95$Unique_scan))

Scans_MSeq_95 <- length(unique(MatchSeq_95$Unique_scan))


dataf_pform_95_Site <- dataf_95_pform[dataf_95_pform$Unique_scan %in% MatchSeq_95$Unique_scan,]

Reduceddataf_95_Site <- subset(dataf_pform_95_Site,select = c(SiteID,Sequence,PTM_Final_prob, PTM_Positions))

Reduceddataf_95_Site <- Reduceddataf_95_Site %>% dplyr::rename(
  pASTY_Score = PTM_Final_prob
)
ReduceddatafA_Site <- subset(datafA,select = c(SiteID,Sequence,PTM_Final_prob, PTM_Positions))

ReduceddatafA_Site <- ReduceddatafA_Site %>% dplyr::rename(
  SequenceSTYA = Sequence,
  PTM_PositionsSTYA = PTM_Positions,
  pASTY_Score = PTM_Final_prob
)

dataf_Merged_95_Site <- merge(x=Reduceddataf_95_Site,y=ReduceddatafA_Site,by="SiteID", all.x = TRUE)

MatchSeq_MSites_95 <- length(dataf_Merged_95_Site$SequenceSTY[!is.na(dataf_Merged_95_Site$SequenceSTYA)])

MatchSeq_NoMSites_95 <- length(dataf_Merged_95_Site$SequenceSTY[is.na(dataf_Merged_95_Site$SequenceSTYA)])

NoMatchSeq_NoMSites_95 <- length(dataf_95_pform$Unique_scan)-length(dataf_Merged_95_Site$SiteID)

Results_95 <- rbind(Scans_NMSeq_95,Scans_MSeq_95,MatchSeq_MSites_95,MatchSeq_NoMSites_95,NoMatchSeq_NoMSites_95)

return(Results_95)

}